package gov.va.med.mhv.usermgmt.form;

import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.util.CalendarUtils;
import org.tigris.atlas.validate.Validations;

/**
 * The AccountActivityCriteriaForm class is responsible for handling user input.
 */
public class AccountActivityCriteriaForm extends AccountActivityCriteriaBaseForm {
	private String toDateRangeFieldLevelErrorMessage;
	private String fromDateRangeFieldLevelErrorMessage;
	
	protected void doReset(ActionMapping mapping, HttpServletRequest request) {
		this.setFromDateDay(null);
		this.setFromDateMonth(null);
		this.setFromDateYear(null);
		this.setToDateDay(null);
		this.setToDateMonth(null);
		this.setToDateYear(null);
		this.setActivityPerformerType(null);
		fromDateRangeFieldLevelErrorMessage = null;
		toDateRangeFieldLevelErrorMessage = null;
	}

	public Date getToDate(){
		return CalendarUtils.getDate(getToDateMonth(), getToDateDay(), getToDateYear() );
	}
	
	public Date getFromDate(){
		return CalendarUtils.getDate(getFromDateMonth(), getFromDateDay(), getFromDateYear() );
	}
	
	public void setFromDate(Date newDate){
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(newDate);
		setFromDateMonth(""+(calendar.get(Calendar.MONTH)+1));
		setFromDateDay(""+calendar.get(Calendar.DAY_OF_MONTH));
		setFromDateYear(""+calendar.get(Calendar.YEAR));
	}
	
	public void setToDate(Date newDate){
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(newDate);
		setToDateMonth(""+(calendar.get(Calendar.MONTH)+1));
		setToDateDay(""+calendar.get(Calendar.DAY_OF_MONTH));
		setToDateYear(""+calendar.get(Calendar.YEAR));
	}
	
	protected void additionalValidation(HttpServletRequest request) {
		super.additionalValidation(request);
		
		Validations.validateDate(getToDateMonth(), getToDateDay(), getToDateYear(), "toDate", "To Date", true, getMessages());
	    Validations.validateDate(getFromDateMonth(), getFromDateDay(), getFromDateYear(), "fromDate", "From Date", true, getMessages());

	    if(!getMessages().hasErrorMessages()){
			Date fromDate =  getFromDate();
			Date toDate =  getToDate();
			
			Calendar twelveMonthsFromToDate = Calendar.getInstance();
			twelveMonthsFromToDate.setTime(toDate);
			twelveMonthsFromToDate.add(Calendar.MONTH, -12);
			
			if(fromDate.compareTo(toDate)>0){
				Message errMsg = MessageUtils.createErrorMessage("error.from.greater", new String[]{"fromDate"}, null);
				getMessages().addMessage(errMsg);
			}
			else if(twelveMonthsFromToDate.getTime().compareTo(fromDate)>0){
				Message errMsg = MessageUtils.createErrorMessage("error.date.span", new String[]{"fromDate"}, null);
				getMessages().addMessage(errMsg);
			}
	    }
	    	
		setFieldLevelErrorMessages(getMessages(), request);
		setMyFieldLevelErrorMessages(getMessages(), request);
	}

	private void setMyFieldLevelErrorMessages(Messages messages, HttpServletRequest request) {
		if (getMessages().getErrorMessageCount("fromDate") > 0) {
			Message message = (Message) messages.getErrorMessages("fromDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			fromDateRangeFieldLevelErrorMessage = errorString;
		} 
		if (getMessages().getErrorMessageCount("toDate") > 0) {
			Message message = (Message) messages.getErrorMessages("toDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			toDateRangeFieldLevelErrorMessage = errorString;
		}
	}

	public String getFromDateRangeErrorMessage() {
		return fromDateRangeFieldLevelErrorMessage;
	}

	public String getToDateRangeErrorMessage() {
		return toDateRangeFieldLevelErrorMessage;
	}
}